<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vault;

class MailOptions extends \Google\Model
{
  /**
   * Encryption status unspecified. Results include both client-side encrypted
   * and non-encrypted content.
   */
  public const CLIENT_SIDE_ENCRYPTED_OPTION_CLIENT_SIDE_ENCRYPTED_OPTION_UNSPECIFIED = 'CLIENT_SIDE_ENCRYPTED_OPTION_UNSPECIFIED';
  /**
   * Include both client-side encrypted and unencrypted content in results.
   */
  public const CLIENT_SIDE_ENCRYPTED_OPTION_CLIENT_SIDE_ENCRYPTED_OPTION_ANY = 'CLIENT_SIDE_ENCRYPTED_OPTION_ANY';
  /**
   * Include client-side encrypted content only.
   */
  public const CLIENT_SIDE_ENCRYPTED_OPTION_CLIENT_SIDE_ENCRYPTED_OPTION_ENCRYPTED = 'CLIENT_SIDE_ENCRYPTED_OPTION_ENCRYPTED';
  /**
   * Include unencrypted content only.
   */
  public const CLIENT_SIDE_ENCRYPTED_OPTION_CLIENT_SIDE_ENCRYPTED_OPTION_UNENCRYPTED = 'CLIENT_SIDE_ENCRYPTED_OPTION_UNENCRYPTED';
  /**
   * Specifies whether the results should include encrypted content, unencrypted
   * content, or both. Defaults to including both.
   *
   * @var string
   */
  public $clientSideEncryptedOption;
  /**
   * Set to **true** to exclude drafts.
   *
   * @var bool
   */
  public $excludeDrafts;

  /**
   * Specifies whether the results should include encrypted content, unencrypted
   * content, or both. Defaults to including both.
   *
   * Accepted values: CLIENT_SIDE_ENCRYPTED_OPTION_UNSPECIFIED,
   * CLIENT_SIDE_ENCRYPTED_OPTION_ANY, CLIENT_SIDE_ENCRYPTED_OPTION_ENCRYPTED,
   * CLIENT_SIDE_ENCRYPTED_OPTION_UNENCRYPTED
   *
   * @param self::CLIENT_SIDE_ENCRYPTED_OPTION_* $clientSideEncryptedOption
   */
  public function setClientSideEncryptedOption($clientSideEncryptedOption)
  {
    $this->clientSideEncryptedOption = $clientSideEncryptedOption;
  }
  /**
   * @return self::CLIENT_SIDE_ENCRYPTED_OPTION_*
   */
  public function getClientSideEncryptedOption()
  {
    return $this->clientSideEncryptedOption;
  }
  /**
   * Set to **true** to exclude drafts.
   *
   * @param bool $excludeDrafts
   */
  public function setExcludeDrafts($excludeDrafts)
  {
    $this->excludeDrafts = $excludeDrafts;
  }
  /**
   * @return bool
   */
  public function getExcludeDrafts()
  {
    return $this->excludeDrafts;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(MailOptions::class, 'Google_Service_Vault_MailOptions');
