<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Vault;

class DriveExportOptions extends \Google\Model
{
  /**
   * To include access level information for users with [indirect
   * access](https://support.google.com/vault/answer/6099459#metadata) to files,
   * set to **true**.
   *
   * @var bool
   */
  public $includeAccessInfo;

  /**
   * To include access level information for users with [indirect
   * access](https://support.google.com/vault/answer/6099459#metadata) to files,
   * set to **true**.
   *
   * @param bool $includeAccessInfo
   */
  public function setIncludeAccessInfo($includeAccessInfo)
  {
    $this->includeAccessInfo = $includeAccessInfo;
  }
  /**
   * @return bool
   */
  public function getIncludeAccessInfo()
  {
    return $this->includeAccessInfo;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DriveExportOptions::class, 'Google_Service_Vault_DriveExportOptions');
