<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Tasks;

class Tasks extends \Google\Collection
{
  protected $collection_key = 'items';
  /**
   * ETag of the resource.
   *
   * @var string
   */
  public $etag;
  protected $itemsType = Task::class;
  protected $itemsDataType = 'array';
  /**
   * Type of the resource. This is always "tasks#tasks".
   *
   * @var string
   */
  public $kind;
  /**
   * Token used to access the next page of this result.
   *
   * @var string
   */
  public $nextPageToken;

  /**
   * ETag of the resource.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Collection of tasks.
   *
   * @param Task[] $items
   */
  public function setItems($items)
  {
    $this->items = $items;
  }
  /**
   * @return Task[]
   */
  public function getItems()
  {
    return $this->items;
  }
  /**
   * Type of the resource. This is always "tasks#tasks".
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Token used to access the next page of this result.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Tasks::class, 'Google_Service_Tasks_Tasks');
