<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Storagetransfer;

class AwsS3CompatibleData extends \Google\Model
{
  /**
   * Required. Specifies the name of the bucket.
   *
   * @var string
   */
  public $bucketName;
  /**
   * Required. Specifies the endpoint of the storage service.
   *
   * @var string
   */
  public $endpoint;
  /**
   * Specifies the root path to transfer objects. Must be an empty string or
   * full path name that ends with a '/'. This field is treated as an object
   * prefix. As such, it should generally not begin with a '/'.
   *
   * @var string
   */
  public $path;
  /**
   * Specifies the region to sign requests with. This can be left blank if
   * requests should be signed with an empty region.
   *
   * @var string
   */
  public $region;
  protected $s3MetadataType = S3CompatibleMetadata::class;
  protected $s3MetadataDataType = '';

  /**
   * Required. Specifies the name of the bucket.
   *
   * @param string $bucketName
   */
  public function setBucketName($bucketName)
  {
    $this->bucketName = $bucketName;
  }
  /**
   * @return string
   */
  public function getBucketName()
  {
    return $this->bucketName;
  }
  /**
   * Required. Specifies the endpoint of the storage service.
   *
   * @param string $endpoint
   */
  public function setEndpoint($endpoint)
  {
    $this->endpoint = $endpoint;
  }
  /**
   * @return string
   */
  public function getEndpoint()
  {
    return $this->endpoint;
  }
  /**
   * Specifies the root path to transfer objects. Must be an empty string or
   * full path name that ends with a '/'. This field is treated as an object
   * prefix. As such, it should generally not begin with a '/'.
   *
   * @param string $path
   */
  public function setPath($path)
  {
    $this->path = $path;
  }
  /**
   * @return string
   */
  public function getPath()
  {
    return $this->path;
  }
  /**
   * Specifies the region to sign requests with. This can be left blank if
   * requests should be signed with an empty region.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * A S3 compatible metadata.
   *
   * @param S3CompatibleMetadata $s3Metadata
   */
  public function setS3Metadata(S3CompatibleMetadata $s3Metadata)
  {
    $this->s3Metadata = $s3Metadata;
  }
  /**
   * @return S3CompatibleMetadata
   */
  public function getS3Metadata()
  {
    return $this->s3Metadata;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AwsS3CompatibleData::class, 'Google_Service_Storagetransfer_AwsS3CompatibleData');
