<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Spanner;

class ScanData extends \Google\Model
{
  protected $dataType = VisualizationData::class;
  protected $dataDataType = '';
  /**
   * The upper bound for when the contained data is defined.
   *
   * @var string
   */
  public $endTime;
  /**
   * A range of time (inclusive) for when the contained data is defined. The
   * lower bound for when the contained data is defined.
   *
   * @var string
   */
  public $startTime;

  /**
   * Cloud Key Visualizer scan data. The range of time this information covers
   * is captured via the above time range fields. Note, this field is not
   * available to the ListScans method.
   *
   * @param VisualizationData $data
   */
  public function setData(VisualizationData $data)
  {
    $this->data = $data;
  }
  /**
   * @return VisualizationData
   */
  public function getData()
  {
    return $this->data;
  }
  /**
   * The upper bound for when the contained data is defined.
   *
   * @param string $endTime
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
  /**
   * A range of time (inclusive) for when the contained data is defined. The
   * lower bound for when the contained data is defined.
   *
   * @param string $startTime
   */
  public function setStartTime($startTime)
  {
    $this->startTime = $startTime;
  }
  /**
   * @return string
   */
  public function getStartTime()
  {
    return $this->startTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ScanData::class, 'Google_Service_Spanner_ScanData');
