<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class ShippingsettingsGetSupportedCarriersResponse extends \Google\Collection
{
  protected $collection_key = 'carriers';
  protected $carriersType = CarriersCarrier::class;
  protected $carriersDataType = 'array';
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#shippingsettingsGetSupportedCarriersResponse`".
   *
   * @var string
   */
  public $kind;

  /**
   * A list of supported carriers. May be empty.
   *
   * @param CarriersCarrier[] $carriers
   */
  public function setCarriers($carriers)
  {
    $this->carriers = $carriers;
  }
  /**
   * @return CarriersCarrier[]
   */
  public function getCarriers()
  {
    return $this->carriers;
  }
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * "`content#shippingsettingsGetSupportedCarriersResponse`".
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ShippingsettingsGetSupportedCarriersResponse::class, 'Google_Service_ShoppingContent_ShippingsettingsGetSupportedCarriersResponse');
