<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\SaaSServiceManagement;

class ReplicationInternal extends \Google\Collection
{
  /**
   * Unspecified state.
   */
  public const STATE_REPLICATION_STATE_UNSPECIFIED = 'REPLICATION_STATE_UNSPECIFIED';
  /**
   * Replication is pending.
   */
  public const STATE_REPLICATION_STATE_PENDING = 'REPLICATION_STATE_PENDING';
  /**
   * Replication is running.
   */
  public const STATE_REPLICATION_STATE_RUNNING = 'REPLICATION_STATE_RUNNING';
  /**
   * Replication has failed.
   */
  public const STATE_REPLICATION_STATE_FAILED = 'REPLICATION_STATE_FAILED';
  /**
   * Replication has succeeded.
   */
  public const STATE_REPLICATION_STATE_SUCCEEDED = 'REPLICATION_STATE_SUCCEEDED';
  protected $collection_key = 'targetLocations';
  /**
   * Optional. Annotations is an unstructured key-value map stored with a
   * resource that may be set by external tools to store and retrieve arbitrary
   * metadata. They are not queryable and should be preserved when modifying
   * objects. More info: https://kubernetes.io/docs/user-guide/annotations
   *
   * @var string[]
   */
  public $annotations;
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @var string
   */
  public $etag;
  /**
   * Optional. The labels on the resource, which can be used for categorization.
   * similar to Kubernetes resource labels.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Optional. The maximum number of retries for the replication. If the
   * replication fails from a retryable error, it will be retried for this
   * number of times.
   *
   * @var int
   */
  public $maxRetryCount;
  /**
   * Identifier. The resource name (full URI of the resource) following the
   * standard naming scheme: "projects/{project}/locations/{location}/replicatio
   * nInternal/{replication_internal_id}"
   *
   * @var string
   */
  public $name;
  /**
   * Required. The payload of the request for replication. It could be any
   * request type that is supported by the replication service. e.g.
   * CreateUnitKindRequest, UpdateUnitKindRequest, DeleteReleaseRequest, etc.
   *
   * @var array[]
   */
  public $payload;
  /**
   * Output only. The state of the replication.
   *
   * @var string
   */
  public $state;
  protected $statsType = ReplicationStats::class;
  protected $statsDataType = 'map';
  /**
   * Optional. The target locations to replicate the resource to.
   *
   * @var string[]
   */
  public $targetLocations;
  /**
   * Output only. The unique identifier of the resource. UID is unique in the
   * time and space for this resource within the scope of the service. It is
   * typically generated by the server on successful creation of a resource and
   * must not be changed. UID is used to uniquely identify resources with
   * resource name reuses. This should be a UUID4.
   *
   * @var string
   */
  public $uid;
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Optional. Annotations is an unstructured key-value map stored with a
   * resource that may be set by external tools to store and retrieve arbitrary
   * metadata. They are not queryable and should be preserved when modifying
   * objects. More info: https://kubernetes.io/docs/user-guide/annotations
   *
   * @param string[] $annotations
   */
  public function setAnnotations($annotations)
  {
    $this->annotations = $annotations;
  }
  /**
   * @return string[]
   */
  public function getAnnotations()
  {
    return $this->annotations;
  }
  /**
   * Output only. The timestamp when the resource was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. An opaque value that uniquely identifies a version or
   * generation of a resource. It can be used to confirm that the client and
   * server agree on the ordering of a resource being written.
   *
   * @param string $etag
   */
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  /**
   * @return string
   */
  public function getEtag()
  {
    return $this->etag;
  }
  /**
   * Optional. The labels on the resource, which can be used for categorization.
   * similar to Kubernetes resource labels.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Optional. The maximum number of retries for the replication. If the
   * replication fails from a retryable error, it will be retried for this
   * number of times.
   *
   * @param int $maxRetryCount
   */
  public function setMaxRetryCount($maxRetryCount)
  {
    $this->maxRetryCount = $maxRetryCount;
  }
  /**
   * @return int
   */
  public function getMaxRetryCount()
  {
    return $this->maxRetryCount;
  }
  /**
   * Identifier. The resource name (full URI of the resource) following the
   * standard naming scheme: "projects/{project}/locations/{location}/replicatio
   * nInternal/{replication_internal_id}"
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Required. The payload of the request for replication. It could be any
   * request type that is supported by the replication service. e.g.
   * CreateUnitKindRequest, UpdateUnitKindRequest, DeleteReleaseRequest, etc.
   *
   * @param array[] $payload
   */
  public function setPayload($payload)
  {
    $this->payload = $payload;
  }
  /**
   * @return array[]
   */
  public function getPayload()
  {
    return $this->payload;
  }
  /**
   * Output only. The state of the replication.
   *
   * Accepted values: REPLICATION_STATE_UNSPECIFIED, REPLICATION_STATE_PENDING,
   * REPLICATION_STATE_RUNNING, REPLICATION_STATE_FAILED,
   * REPLICATION_STATE_SUCCEEDED
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * Output only. The stats of the replication. One key for each location in
   * target_locations
   *
   * @param ReplicationStats[] $stats
   */
  public function setStats($stats)
  {
    $this->stats = $stats;
  }
  /**
   * @return ReplicationStats[]
   */
  public function getStats()
  {
    return $this->stats;
  }
  /**
   * Optional. The target locations to replicate the resource to.
   *
   * @param string[] $targetLocations
   */
  public function setTargetLocations($targetLocations)
  {
    $this->targetLocations = $targetLocations;
  }
  /**
   * @return string[]
   */
  public function getTargetLocations()
  {
    return $this->targetLocations;
  }
  /**
   * Output only. The unique identifier of the resource. UID is unique in the
   * time and space for this resource within the scope of the service. It is
   * typically generated by the server on successful creation of a resource and
   * must not be changed. UID is used to uniquely identify resources with
   * resource name reuses. This should be a UUID4.
   *
   * @param string $uid
   */
  public function setUid($uid)
  {
    $this->uid = $uid;
  }
  /**
   * @return string
   */
  public function getUid()
  {
    return $this->uid;
  }
  /**
   * Output only. The timestamp when the resource was last updated. Any change
   * to the resource made by users must refresh this value. Changes to a
   * resource made by the service should refresh this value.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ReplicationInternal::class, 'Google_Service_SaaSServiceManagement_ReplicationInternal');
