<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Playdeveloperreporting;

class GooglePlayDeveloperReportingV1beta1SlowRenderingRateMetricSet extends \Google\Model
{
  protected $freshnessInfoType = GooglePlayDeveloperReportingV1beta1FreshnessInfo::class;
  protected $freshnessInfoDataType = '';
  /**
   * Identifier. The resource name. Format:
   * apps/{app}/slowRenderingRateMetricSet
   *
   * @var string
   */
  public $name;

  /**
   * Summary about data freshness in this resource.
   *
   * @param GooglePlayDeveloperReportingV1beta1FreshnessInfo $freshnessInfo
   */
  public function setFreshnessInfo(GooglePlayDeveloperReportingV1beta1FreshnessInfo $freshnessInfo)
  {
    $this->freshnessInfo = $freshnessInfo;
  }
  /**
   * @return GooglePlayDeveloperReportingV1beta1FreshnessInfo
   */
  public function getFreshnessInfo()
  {
    return $this->freshnessInfo;
  }
  /**
   * Identifier. The resource name. Format:
   * apps/{app}/slowRenderingRateMetricSet
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GooglePlayDeveloperReportingV1beta1SlowRenderingRateMetricSet::class, 'Google_Service_Playdeveloperreporting_GooglePlayDeveloperReportingV1beta1SlowRenderingRateMetricSet');
