<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class Snooze extends \Google\Model
{
  protected $criteriaType = Criteria::class;
  protected $criteriaDataType = '';
  /**
   * Required. A display name for the Snooze. This can be, at most, 512 unicode
   * characters.
   *
   * @var string
   */
  public $displayName;
  protected $intervalType = TimeInterval::class;
  protected $intervalDataType = '';
  /**
   * Required. Identifier. The name of the Snooze. The format is:
   * projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID] The ID of the Snooze
   * will be generated by the system.
   *
   * @var string
   */
  public $name;

  /**
   * Required. This defines the criteria for applying the Snooze. See Criteria
   * for more information.
   *
   * @param Criteria $criteria
   */
  public function setCriteria(Criteria $criteria)
  {
    $this->criteria = $criteria;
  }
  /**
   * @return Criteria
   */
  public function getCriteria()
  {
    return $this->criteria;
  }
  /**
   * Required. A display name for the Snooze. This can be, at most, 512 unicode
   * characters.
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * Required. The Snooze will be active from interval.start_time through
   * interval.end_time. interval.start_time cannot be in the past. There is a 15
   * second clock skew to account for the time it takes for a request to reach
   * the API from the UI.
   *
   * @param TimeInterval $interval
   */
  public function setInterval(TimeInterval $interval)
  {
    $this->interval = $interval;
  }
  /**
   * @return TimeInterval
   */
  public function getInterval()
  {
    return $this->interval;
  }
  /**
   * Required. Identifier. The name of the Snooze. The format is:
   * projects/[PROJECT_ID_OR_NUMBER]/snoozes/[SNOOZE_ID] The ID of the Snooze
   * will be generated by the system.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Snooze::class, 'Google_Service_Monitoring_Snooze');
