<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Monitoring;

class Link extends \Google\Model
{
  /**
   * A short display name for the link. The display name must not be empty or
   * exceed 63 characters. Example: "playbook".
   *
   * @var string
   */
  public $displayName;
  /**
   * The url of a webpage. A url can be templatized by using variables in the
   * path or the query parameters. The total length of a URL should not exceed
   * 2083 characters before and after variable expansion. Example:
   * "https://my_domain.com/playbook?name=${resource.name}"
   *
   * @var string
   */
  public $url;

  /**
   * A short display name for the link. The display name must not be empty or
   * exceed 63 characters. Example: "playbook".
   *
   * @param string $displayName
   */
  public function setDisplayName($displayName)
  {
    $this->displayName = $displayName;
  }
  /**
   * @return string
   */
  public function getDisplayName()
  {
    return $this->displayName;
  }
  /**
   * The url of a webpage. A url can be templatized by using variables in the
   * path or the query parameters. The total length of a URL should not exceed
   * 2083 characters before and after variable expansion. Example:
   * "https://my_domain.com/playbook?name=${resource.name}"
   *
   * @param string $url
   */
  public function setUrl($url)
  {
    $this->url = $url;
  }
  /**
   * @return string
   */
  public function getUrl()
  {
    return $this->url;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Link::class, 'Google_Service_Monitoring_Link');
