<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MigrationCenterAPI;

class ReportSummaryVmwareNode extends \Google\Model
{
  /**
   * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
   * on the displayName of cloud.google.com/vmware-
   * engine/docs/reference/rest/v1/projects.locations.nodeTypes
   *
   * @var string
   */
  public $code;

  /**
   * Code to identify VMware Engine node series, e.g. "ve1-standard-72". Based
   * on the displayName of cloud.google.com/vmware-
   * engine/docs/reference/rest/v1/projects.locations.nodeTypes
   *
   * @param string $code
   */
  public function setCode($code)
  {
    $this->code = $code;
  }
  /**
   * @return string
   */
  public function getCode()
  {
    return $this->code;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ReportSummaryVmwareNode::class, 'Google_Service_MigrationCenterAPI_ReportSummaryVmwareNode');
