<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Integrations;

class GoogleCloudIntegrationsV1alphaParameterMapEntry extends \Google\Model
{
  protected $keyType = GoogleCloudIntegrationsV1alphaParameterMapField::class;
  protected $keyDataType = '';
  protected $valueType = GoogleCloudIntegrationsV1alphaParameterMapField::class;
  protected $valueDataType = '';

  /**
   * Key of the map entry.
   *
   * @param GoogleCloudIntegrationsV1alphaParameterMapField $key
   */
  public function setKey(GoogleCloudIntegrationsV1alphaParameterMapField $key)
  {
    $this->key = $key;
  }
  /**
   * @return GoogleCloudIntegrationsV1alphaParameterMapField
   */
  public function getKey()
  {
    return $this->key;
  }
  /**
   * Value of the map entry.
   *
   * @param GoogleCloudIntegrationsV1alphaParameterMapField $value
   */
  public function setValue(GoogleCloudIntegrationsV1alphaParameterMapField $value)
  {
    $this->value = $value;
  }
  /**
   * @return GoogleCloudIntegrationsV1alphaParameterMapField
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudIntegrationsV1alphaParameterMapEntry::class, 'Google_Service_Integrations_GoogleCloudIntegrationsV1alphaParameterMapEntry');
