<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DriveLabels;

class GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice extends \Google\Model
{
  protected $appliedCapabilitiesType = GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities::class;
  protected $appliedCapabilitiesDataType = '';
  /**
   * Output only. The time this choice was created.
   *
   * @var string
   */
  public $createTime;
  protected $creatorType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $creatorDataType = '';
  /**
   * Output only. The time this choice was disabled. This value has no meaning
   * when the choice is not disabled.
   *
   * @var string
   */
  public $disableTime;
  protected $disablerType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $disablerDataType = '';
  protected $displayHintsType = GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints::class;
  protected $displayHintsDataType = '';
  /**
   * The unique value of the choice. This ID is autogenerated. Matches the
   * regex: `([a-zA-Z0-9_])+`.
   *
   * @var string
   */
  public $id;
  protected $lifecycleType = GoogleAppsDriveLabelsV2Lifecycle::class;
  protected $lifecycleDataType = '';
  protected $lockStatusType = GoogleAppsDriveLabelsV2LockStatus::class;
  protected $lockStatusDataType = '';
  protected $propertiesType = GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties::class;
  protected $propertiesDataType = '';
  /**
   * Output only. The time this choice was published. This value has no meaning
   * when the choice is not published.
   *
   * @var string
   */
  public $publishTime;
  protected $publisherType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $publisherDataType = '';
  protected $schemaCapabilitiesType = GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities::class;
  protected $schemaCapabilitiesDataType = '';
  /**
   * Output only. The time this choice was updated last.
   *
   * @var string
   */
  public $updateTime;
  protected $updaterType = GoogleAppsDriveLabelsV2UserInfo::class;
  protected $updaterDataType = '';

  /**
   * Output only. The capabilities related to this choice on applied metadata.
   *
   * @param GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities $appliedCapabilities
   */
  public function setAppliedCapabilities(GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities $appliedCapabilities)
  {
    $this->appliedCapabilities = $appliedCapabilities;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceAppliedCapabilities
   */
  public function getAppliedCapabilities()
  {
    return $this->appliedCapabilities;
  }
  /**
   * Output only. The time this choice was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. The user who created this choice.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $creator
   */
  public function setCreator(GoogleAppsDriveLabelsV2UserInfo $creator)
  {
    $this->creator = $creator;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getCreator()
  {
    return $this->creator;
  }
  /**
   * Output only. The time this choice was disabled. This value has no meaning
   * when the choice is not disabled.
   *
   * @param string $disableTime
   */
  public function setDisableTime($disableTime)
  {
    $this->disableTime = $disableTime;
  }
  /**
   * @return string
   */
  public function getDisableTime()
  {
    return $this->disableTime;
  }
  /**
   * Output only. The user who disabled this choice. This value has no meaning
   * when the option is not disabled.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $disabler
   */
  public function setDisabler(GoogleAppsDriveLabelsV2UserInfo $disabler)
  {
    $this->disabler = $disabler;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getDisabler()
  {
    return $this->disabler;
  }
  /**
   * Output only. UI display hints for rendering a choice.
   *
   * @param GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints $displayHints
   */
  public function setDisplayHints(GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints $displayHints)
  {
    $this->displayHints = $displayHints;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceDisplayHints
   */
  public function getDisplayHints()
  {
    return $this->displayHints;
  }
  /**
   * The unique value of the choice. This ID is autogenerated. Matches the
   * regex: `([a-zA-Z0-9_])+`.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. Lifecycle of the choice.
   *
   * @param GoogleAppsDriveLabelsV2Lifecycle $lifecycle
   */
  public function setLifecycle(GoogleAppsDriveLabelsV2Lifecycle $lifecycle)
  {
    $this->lifecycle = $lifecycle;
  }
  /**
   * @return GoogleAppsDriveLabelsV2Lifecycle
   */
  public function getLifecycle()
  {
    return $this->lifecycle;
  }
  /**
   * Output only. The `LockStatus` of this choice.
   *
   * @param GoogleAppsDriveLabelsV2LockStatus $lockStatus
   */
  public function setLockStatus(GoogleAppsDriveLabelsV2LockStatus $lockStatus)
  {
    $this->lockStatus = $lockStatus;
  }
  /**
   * @return GoogleAppsDriveLabelsV2LockStatus
   */
  public function getLockStatus()
  {
    return $this->lockStatus;
  }
  /**
   * Basic properties of the choice.
   *
   * @param GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties $properties
   */
  public function setProperties(GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties $properties)
  {
    $this->properties = $properties;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceProperties
   */
  public function getProperties()
  {
    return $this->properties;
  }
  /**
   * Output only. The time this choice was published. This value has no meaning
   * when the choice is not published.
   *
   * @param string $publishTime
   */
  public function setPublishTime($publishTime)
  {
    $this->publishTime = $publishTime;
  }
  /**
   * @return string
   */
  public function getPublishTime()
  {
    return $this->publishTime;
  }
  /**
   * Output only. The user who published this choice. This value has no meaning
   * when the choice is not published.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $publisher
   */
  public function setPublisher(GoogleAppsDriveLabelsV2UserInfo $publisher)
  {
    $this->publisher = $publisher;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getPublisher()
  {
    return $this->publisher;
  }
  /**
   * Output only. The capabilities related to this option when editing the
   * option.
   *
   * @param GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities $schemaCapabilities
   */
  public function setSchemaCapabilities(GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities $schemaCapabilities)
  {
    $this->schemaCapabilities = $schemaCapabilities;
  }
  /**
   * @return GoogleAppsDriveLabelsV2FieldSelectionOptionsChoiceSchemaCapabilities
   */
  public function getSchemaCapabilities()
  {
    return $this->schemaCapabilities;
  }
  /**
   * Output only. The time this choice was updated last.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
  /**
   * Output only. The user who updated this choice last.
   *
   * @param GoogleAppsDriveLabelsV2UserInfo $updater
   */
  public function setUpdater(GoogleAppsDriveLabelsV2UserInfo $updater)
  {
    $this->updater = $updater;
  }
  /**
   * @return GoogleAppsDriveLabelsV2UserInfo
   */
  public function getUpdater()
  {
    return $this->updater;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice::class, 'Google_Service_DriveLabels_GoogleAppsDriveLabelsV2FieldSelectionOptionsChoice');
