<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Doubleclicksearch;

class Report extends \Google\Collection
{
  protected $collection_key = 'rows';
  protected $filesType = ReportFiles::class;
  protected $filesDataType = 'array';
  /**
   * Asynchronous report only. Id of the report.
   *
   * @var string
   */
  public $id;
  /**
   * Asynchronous report only. True if and only if the report has completed
   * successfully and the report files are ready to be downloaded.
   *
   * @var bool
   */
  public $isReportReady;
  /**
   * Identifies this as a Report resource. Value: the fixed string
   * `doubleclicksearch#report`.
   *
   * @var string
   */
  public $kind;
  protected $requestType = ReportRequest::class;
  protected $requestDataType = '';
  /**
   * The number of report rows generated by the report, not including headers.
   *
   * @var int
   */
  public $rowCount;
  /**
   * Synchronous report only. Generated report rows.
   *
   * @var array[]
   */
  public $rows;
  /**
   * The currency code of all monetary values produced in the report, including
   * values that are set by users (e.g., keyword bid settings) and metrics
   * (e.g., cost and revenue). The currency code of a report is determined by
   * the `statisticsCurrency` field of the report request.
   *
   * @var string
   */
  public $statisticsCurrencyCode;
  /**
   * If all statistics of the report are sourced from the same time zone, this
   * would be it. Otherwise the field is unset.
   *
   * @var string
   */
  public $statisticsTimeZone;

  /**
   * Asynchronous report only. Contains a list of generated report files once
   * the report has successfully completed.
   *
   * @param ReportFiles[] $files
   */
  public function setFiles($files)
  {
    $this->files = $files;
  }
  /**
   * @return ReportFiles[]
   */
  public function getFiles()
  {
    return $this->files;
  }
  /**
   * Asynchronous report only. Id of the report.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Asynchronous report only. True if and only if the report has completed
   * successfully and the report files are ready to be downloaded.
   *
   * @param bool $isReportReady
   */
  public function setIsReportReady($isReportReady)
  {
    $this->isReportReady = $isReportReady;
  }
  /**
   * @return bool
   */
  public function getIsReportReady()
  {
    return $this->isReportReady;
  }
  /**
   * Identifies this as a Report resource. Value: the fixed string
   * `doubleclicksearch#report`.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The request that created the report. Optional fields not specified in the
   * original request are filled with default values.
   *
   * @param ReportRequest $request
   */
  public function setRequest(ReportRequest $request)
  {
    $this->request = $request;
  }
  /**
   * @return ReportRequest
   */
  public function getRequest()
  {
    return $this->request;
  }
  /**
   * The number of report rows generated by the report, not including headers.
   *
   * @param int $rowCount
   */
  public function setRowCount($rowCount)
  {
    $this->rowCount = $rowCount;
  }
  /**
   * @return int
   */
  public function getRowCount()
  {
    return $this->rowCount;
  }
  /**
   * Synchronous report only. Generated report rows.
   *
   * @param array[] $rows
   */
  public function setRows($rows)
  {
    $this->rows = $rows;
  }
  /**
   * @return array[]
   */
  public function getRows()
  {
    return $this->rows;
  }
  /**
   * The currency code of all monetary values produced in the report, including
   * values that are set by users (e.g., keyword bid settings) and metrics
   * (e.g., cost and revenue). The currency code of a report is determined by
   * the `statisticsCurrency` field of the report request.
   *
   * @param string $statisticsCurrencyCode
   */
  public function setStatisticsCurrencyCode($statisticsCurrencyCode)
  {
    $this->statisticsCurrencyCode = $statisticsCurrencyCode;
  }
  /**
   * @return string
   */
  public function getStatisticsCurrencyCode()
  {
    return $this->statisticsCurrencyCode;
  }
  /**
   * If all statistics of the report are sourced from the same time zone, this
   * would be it. Otherwise the field is unset.
   *
   * @param string $statisticsTimeZone
   */
  public function setStatisticsTimeZone($statisticsTimeZone)
  {
    $this->statisticsTimeZone = $statisticsTimeZone;
  }
  /**
   * @return string
   */
  public function getStatisticsTimeZone()
  {
    return $this->statisticsTimeZone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Report::class, 'Google_Service_Doubleclicksearch_Report');
