<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Doubleclicksearch;

class ConversionList extends \Google\Collection
{
  protected $collection_key = 'conversion';
  protected $conversionType = Conversion::class;
  protected $conversionDataType = 'array';
  /**
   * Identifies this as a ConversionList resource. Value: the fixed string
   * doubleclicksearch#conversionList.
   *
   * @var string
   */
  public $kind;

  /**
   * The conversions being requested.
   *
   * @param Conversion[] $conversion
   */
  public function setConversion($conversion)
  {
    $this->conversion = $conversion;
  }
  /**
   * @return Conversion[]
   */
  public function getConversion()
  {
    return $this->conversion;
  }
  /**
   * Identifies this as a ConversionList resource. Value: the fixed string
   * doubleclicksearch#conversionList.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ConversionList::class, 'Google_Service_Doubleclicksearch_ConversionList');
