<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class PartnerAdServerConfig extends \Google\Model
{
  protected $measurementConfigType = MeasurementConfig::class;
  protected $measurementConfigDataType = '';

  /**
   * Measurement settings of a partner.
   *
   * @param MeasurementConfig $measurementConfig
   */
  public function setMeasurementConfig(MeasurementConfig $measurementConfig)
  {
    $this->measurementConfig = $measurementConfig;
  }
  /**
   * @return MeasurementConfig
   */
  public function getMeasurementConfig()
  {
    return $this->measurementConfig;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PartnerAdServerConfig::class, 'Google_Service_DisplayVideo_PartnerAdServerConfig');
