<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DisplayVideo;

class ListUsersResponse extends \Google\Collection
{
  protected $collection_key = 'users';
  /**
   * A token to retrieve the next page of results. Pass this value in the
   * page_token field in the subsequent call to `ListUsers` method to retrieve
   * the next page of results. This token will be absent if there are no more
   * results to return.
   *
   * @var string
   */
  public $nextPageToken;
  protected $usersType = User::class;
  protected $usersDataType = 'array';

  /**
   * A token to retrieve the next page of results. Pass this value in the
   * page_token field in the subsequent call to `ListUsers` method to retrieve
   * the next page of results. This token will be absent if there are no more
   * results to return.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * The list of users. This list will be absent if empty.
   *
   * @param User[] $users
   */
  public function setUsers($users)
  {
    $this->users = $users;
  }
  /**
   * @return User[]
   */
  public function getUsers()
  {
    return $this->users;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListUsersResponse::class, 'Google_Service_DisplayVideo_ListUsersResponse');
