<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataproc;

class InjectCredentialsRequest extends \Google\Model
{
  /**
   * Required. The cluster UUID.
   *
   * @var string
   */
  public $clusterUuid;
  /**
   * Required. The encrypted credentials being injected in to the cluster.The
   * client is responsible for encrypting the credentials in a way that is
   * supported by the cluster.A wrapped value is used here so that the actual
   * contents of the encrypted credentials are not written to audit logs.
   *
   * @var string
   */
  public $credentialsCiphertext;

  /**
   * Required. The cluster UUID.
   *
   * @param string $clusterUuid
   */
  public function setClusterUuid($clusterUuid)
  {
    $this->clusterUuid = $clusterUuid;
  }
  /**
   * @return string
   */
  public function getClusterUuid()
  {
    return $this->clusterUuid;
  }
  /**
   * Required. The encrypted credentials being injected in to the cluster.The
   * client is responsible for encrypting the credentials in a way that is
   * supported by the cluster.A wrapped value is used here so that the actual
   * contents of the encrypted credentials are not written to audit logs.
   *
   * @param string $credentialsCiphertext
   */
  public function setCredentialsCiphertext($credentialsCiphertext)
  {
    $this->credentialsCiphertext = $credentialsCiphertext;
  }
  /**
   * @return string
   */
  public function getCredentialsCiphertext()
  {
    return $this->credentialsCiphertext;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InjectCredentialsRequest::class, 'Google_Service_Dataproc_InjectCredentialsRequest');
