<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class InstanceGroup extends \Google\Collection
{
  protected $collection_key = 'namedPorts';
  /**
   * Output only. [Output Only] The creation timestamp for this instance group
   * inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  /**
   * Output only. [Output Only] The fingerprint of the named ports. The system
   * uses this fingerprint to detect conflicts when multiple users change the
   * named ports concurrently.
   *
   * @var string
   */
  public $fingerprint;
  /**
   * Output only. [Output Only] A unique identifier for this instance group,
   * generated by the server.
   *
   * @var string
   */
  public $id;
  /**
   * Output only. [Output Only] The resource type, which is
   * alwayscompute#instanceGroup for instance groups.
   *
   * @var string
   */
  public $kind;
  /**
   * The name of the instance group. The name must be 1-63 characters long, and
   * comply withRFC1035.
   *
   * @var string
   */
  public $name;
  protected $namedPortsType = NamedPort::class;
  protected $namedPortsDataType = 'array';
  /**
   * [Output Only] The URL of the network to which all instances in the instance
   * group belong. If your instance has multiple network interfaces, then the
   * network and subnetwork fields only refer to the network and subnet used by
   * your primary interface (nic0).
   *
   * @var string
   */
  public $network;
  /**
   * Output only. [Output Only] The URL of theregion where the instance group is
   * located (for regional resources).
   *
   * @var string
   */
  public $region;
  /**
   * Output only. [Output Only] The URL for this instance group. The server
   * generates this URL.
   *
   * @var string
   */
  public $selfLink;
  /**
   * Output only. [Output Only] The total number of instances in the instance
   * group.
   *
   * @var int
   */
  public $size;
  /**
   * Output only. [Output Only] The URL of the subnetwork to which all instances
   * in the instance group belong. If your instance has multiple network
   * interfaces, then the network and subnetwork fields only refer to the
   * network and subnet used by your primary interface (nic0).
   *
   * @var string
   */
  public $subnetwork;
  /**
   * Output only. [Output Only] The URL of thezone where the instance group is
   * located (for zonal resources).
   *
   * @var string
   */
  public $zone;

  /**
   * Output only. [Output Only] The creation timestamp for this instance group
   * inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Output only. [Output Only] The fingerprint of the named ports. The system
   * uses this fingerprint to detect conflicts when multiple users change the
   * named ports concurrently.
   *
   * @param string $fingerprint
   */
  public function setFingerprint($fingerprint)
  {
    $this->fingerprint = $fingerprint;
  }
  /**
   * @return string
   */
  public function getFingerprint()
  {
    return $this->fingerprint;
  }
  /**
   * Output only. [Output Only] A unique identifier for this instance group,
   * generated by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. [Output Only] The resource type, which is
   * alwayscompute#instanceGroup for instance groups.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The name of the instance group. The name must be 1-63 characters long, and
   * comply withRFC1035.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. Assigns a name to a port number. For example:{name: "http", port:
   * 80}
   *
   * This allows the system to reference ports by the assigned name instead of a
   * port number. Named ports can also contain multiple ports. For
   * example:[{name: "app1", port: 8080}, {name: "app1", port: 8081}, {name:
   * "app2", port: 8082}]
   *
   * Named ports apply to all instances in this instance group.
   *
   * @param NamedPort[] $namedPorts
   */
  public function setNamedPorts($namedPorts)
  {
    $this->namedPorts = $namedPorts;
  }
  /**
   * @return NamedPort[]
   */
  public function getNamedPorts()
  {
    return $this->namedPorts;
  }
  /**
   * [Output Only] The URL of the network to which all instances in the instance
   * group belong. If your instance has multiple network interfaces, then the
   * network and subnetwork fields only refer to the network and subnet used by
   * your primary interface (nic0).
   *
   * @param string $network
   */
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  /**
   * @return string
   */
  public function getNetwork()
  {
    return $this->network;
  }
  /**
   * Output only. [Output Only] The URL of theregion where the instance group is
   * located (for regional resources).
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * Output only. [Output Only] The URL for this instance group. The server
   * generates this URL.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Output only. [Output Only] The total number of instances in the instance
   * group.
   *
   * @param int $size
   */
  public function setSize($size)
  {
    $this->size = $size;
  }
  /**
   * @return int
   */
  public function getSize()
  {
    return $this->size;
  }
  /**
   * Output only. [Output Only] The URL of the subnetwork to which all instances
   * in the instance group belong. If your instance has multiple network
   * interfaces, then the network and subnetwork fields only refer to the
   * network and subnet used by your primary interface (nic0).
   *
   * @param string $subnetwork
   */
  public function setSubnetwork($subnetwork)
  {
    $this->subnetwork = $subnetwork;
  }
  /**
   * @return string
   */
  public function getSubnetwork()
  {
    return $this->subnetwork;
  }
  /**
   * Output only. [Output Only] The URL of thezone where the instance group is
   * located (for zonal resources).
   *
   * @param string $zone
   */
  public function setZone($zone)
  {
    $this->zone = $zone;
  }
  /**
   * @return string
   */
  public function getZone()
  {
    return $this->zone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InstanceGroup::class, 'Google_Service_Compute_InstanceGroup');
