<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Chromewebstore;

class FetchItemStatusResponse extends \Google\Model
{
  /**
   * The default value.
   */
  public const LAST_ASYNC_UPLOAD_STATE_UPLOAD_STATE_UNSPECIFIED = 'UPLOAD_STATE_UNSPECIFIED';
  /**
   * The upload succeeded.
   */
  public const LAST_ASYNC_UPLOAD_STATE_SUCCEEDED = 'SUCCEEDED';
  /**
   * The upload is currently being processed.
   */
  public const LAST_ASYNC_UPLOAD_STATE_IN_PROGRESS = 'IN_PROGRESS';
  /**
   * The upload failed.
   */
  public const LAST_ASYNC_UPLOAD_STATE_FAILED = 'FAILED';
  /**
   * Used as the value of `lastAsyncUploadState` in a `fetchStatus` response
   * indicating that an upload attempt was not found.
   */
  public const LAST_ASYNC_UPLOAD_STATE_NOT_FOUND = 'NOT_FOUND';
  /**
   * Output only. The ID of the item.
   *
   * @var string
   */
  public $itemId;
  /**
   * Output only. The state of the last async upload for an item. Only set when
   * there has been an async upload for the item in the past 24 hours.
   *
   * @var string
   */
  public $lastAsyncUploadState;
  /**
   * The name of the requested item.
   *
   * @var string
   */
  public $name;
  /**
   * The public key of the item, which may be generated by the store.
   *
   * @var string
   */
  public $publicKey;
  protected $publishedItemRevisionStatusType = ItemRevisionStatus::class;
  protected $publishedItemRevisionStatusDataType = '';
  protected $submittedItemRevisionStatusType = ItemRevisionStatus::class;
  protected $submittedItemRevisionStatusDataType = '';
  /**
   * If true, the item has been taken down for a policy violation. Check the
   * developer dashboard for details.
   *
   * @var bool
   */
  public $takenDown;
  /**
   * If true, the item has been warned for a policy violation and will be taken
   * down if not resolved. Check the developer dashboard for details.
   *
   * @var bool
   */
  public $warned;

  /**
   * Output only. The ID of the item.
   *
   * @param string $itemId
   */
  public function setItemId($itemId)
  {
    $this->itemId = $itemId;
  }
  /**
   * @return string
   */
  public function getItemId()
  {
    return $this->itemId;
  }
  /**
   * Output only. The state of the last async upload for an item. Only set when
   * there has been an async upload for the item in the past 24 hours.
   *
   * Accepted values: UPLOAD_STATE_UNSPECIFIED, SUCCEEDED, IN_PROGRESS, FAILED,
   * NOT_FOUND
   *
   * @param self::LAST_ASYNC_UPLOAD_STATE_* $lastAsyncUploadState
   */
  public function setLastAsyncUploadState($lastAsyncUploadState)
  {
    $this->lastAsyncUploadState = $lastAsyncUploadState;
  }
  /**
   * @return self::LAST_ASYNC_UPLOAD_STATE_*
   */
  public function getLastAsyncUploadState()
  {
    return $this->lastAsyncUploadState;
  }
  /**
   * The name of the requested item.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The public key of the item, which may be generated by the store.
   *
   * @param string $publicKey
   */
  public function setPublicKey($publicKey)
  {
    $this->publicKey = $publicKey;
  }
  /**
   * @return string
   */
  public function getPublicKey()
  {
    return $this->publicKey;
  }
  /**
   * Output only. Status of the current published revision of the item. Will be
   * unset if the item is not published.
   *
   * @param ItemRevisionStatus $publishedItemRevisionStatus
   */
  public function setPublishedItemRevisionStatus(ItemRevisionStatus $publishedItemRevisionStatus)
  {
    $this->publishedItemRevisionStatus = $publishedItemRevisionStatus;
  }
  /**
   * @return ItemRevisionStatus
   */
  public function getPublishedItemRevisionStatus()
  {
    return $this->publishedItemRevisionStatus;
  }
  /**
   * Status of the item revision submitted to be published. Will be unset if the
   * item has not been submitted for publishing since the last successful
   * publish.
   *
   * @param ItemRevisionStatus $submittedItemRevisionStatus
   */
  public function setSubmittedItemRevisionStatus(ItemRevisionStatus $submittedItemRevisionStatus)
  {
    $this->submittedItemRevisionStatus = $submittedItemRevisionStatus;
  }
  /**
   * @return ItemRevisionStatus
   */
  public function getSubmittedItemRevisionStatus()
  {
    return $this->submittedItemRevisionStatus;
  }
  /**
   * If true, the item has been taken down for a policy violation. Check the
   * developer dashboard for details.
   *
   * @param bool $takenDown
   */
  public function setTakenDown($takenDown)
  {
    $this->takenDown = $takenDown;
  }
  /**
   * @return bool
   */
  public function getTakenDown()
  {
    return $this->takenDown;
  }
  /**
   * If true, the item has been warned for a policy violation and will be taken
   * down if not resolved. Check the developer dashboard for details.
   *
   * @param bool $warned
   */
  public function setWarned($warned)
  {
    $this->warned = $warned;
  }
  /**
   * @return bool
   */
  public function getWarned()
  {
    return $this->warned;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(FetchItemStatusResponse::class, 'Google_Service_Chromewebstore_FetchItemStatusResponse');
