<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BinaryAuthorization;

class AdmissionWhitelistPattern extends \Google\Model
{
  /**
   * An image name pattern to allowlist, in the form `registry/path/to/image`.
   * This supports a trailing `*` wildcard, but this is allowed only in text
   * after the `registry/` part. This also supports a trailing `**` wildcard
   * which matches subdirectories of a given entry.
   *
   * @var string
   */
  public $namePattern;

  /**
   * An image name pattern to allowlist, in the form `registry/path/to/image`.
   * This supports a trailing `*` wildcard, but this is allowed only in text
   * after the `registry/` part. This also supports a trailing `**` wildcard
   * which matches subdirectories of a given entry.
   *
   * @param string $namePattern
   */
  public function setNamePattern($namePattern)
  {
    $this->namePattern = $namePattern;
  }
  /**
   * @return string
   */
  public function getNamePattern()
  {
    return $this->namePattern;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AdmissionWhitelistPattern::class, 'Google_Service_BinaryAuthorization_AdmissionWhitelistPattern');
