<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\BigQueryDataTransfer;

class EventDrivenSchedule extends \Google\Model
{
  /**
   * Pub/Sub subscription name used to receive events. Only Google Cloud Storage
   * data source support this option. Format:
   * projects/{project}/subscriptions/{subscription}
   *
   * @var string
   */
  public $pubsubSubscription;

  /**
   * Pub/Sub subscription name used to receive events. Only Google Cloud Storage
   * data source support this option. Format:
   * projects/{project}/subscriptions/{subscription}
   *
   * @param string $pubsubSubscription
   */
  public function setPubsubSubscription($pubsubSubscription)
  {
    $this->pubsubSubscription = $pubsubSubscription;
  }
  /**
   * @return string
   */
  public function getPubsubSubscription()
  {
    return $this->pubsubSubscription;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EventDrivenSchedule::class, 'Google_Service_BigQueryDataTransfer_EventDrivenSchedule');
