<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Baremetalsolution;

class Network extends \Google\Collection
{
  /**
   * The Network is in an unknown state.
   */
  public const STATE_STATE_UNSPECIFIED = 'STATE_UNSPECIFIED';
  /**
   * The Network is provisioning.
   */
  public const STATE_PROVISIONING = 'PROVISIONING';
  /**
   * The Network has been provisioned.
   */
  public const STATE_PROVISIONED = 'PROVISIONED';
  /**
   * The Network is being deprovisioned.
   */
  public const STATE_DEPROVISIONING = 'DEPROVISIONING';
  /**
   * The Network is being updated.
   */
  public const STATE_UPDATING = 'UPDATING';
  /**
   * Unspecified value.
   */
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  /**
   * Client network, a network peered to a Google Cloud VPC.
   */
  public const TYPE_CLIENT = 'CLIENT';
  /**
   * Private network, a network local to the Bare Metal Solution environment.
   */
  public const TYPE_PRIVATE = 'PRIVATE';
  protected $collection_key = 'reservations';
  /**
   * The cidr of the Network.
   *
   * @var string
   */
  public $cidr;
  /**
   * Output only. Gateway ip address.
   *
   * @var string
   */
  public $gatewayIp;
  /**
   * An identifier for the `Network`, generated by the backend.
   *
   * @var string
   */
  public $id;
  /**
   * IP address configured.
   *
   * @var string
   */
  public $ipAddress;
  /**
   * Whether network uses standard frames or jumbo ones.
   *
   * @var bool
   */
  public $jumboFramesEnabled;
  /**
   * Labels as key value pairs.
   *
   * @var string[]
   */
  public $labels;
  /**
   * List of physical interfaces.
   *
   * @var string[]
   */
  public $macAddress;
  protected $mountPointsType = NetworkMountPoint::class;
  protected $mountPointsDataType = 'array';
  /**
   * Output only. The resource name of this `Network`. Resource names are
   * schemeless URIs that follow the conventions in
   * https://cloud.google.com/apis/design/resource_names. Format:
   * `projects/{project}/locations/{location}/networks/{network}`
   *
   * @var string
   */
  public $name;
  /**
   * Immutable. Pod name. Pod is an independent part of infrastructure. Network
   * can only be connected to the assets (instances, nfsshares) allocated in the
   * same pod.
   *
   * @var string
   */
  public $pod;
  protected $reservationsType = NetworkAddressReservation::class;
  protected $reservationsDataType = 'array';
  /**
   * IP range for reserved for services (e.g. NFS).
   *
   * @var string
   */
  public $servicesCidr;
  /**
   * The Network state.
   *
   * @var string
   */
  public $state;
  /**
   * The type of this network.
   *
   * @var string
   */
  public $type;
  /**
   * The vlan id of the Network.
   *
   * @var string
   */
  public $vlanId;
  protected $vrfType = VRF::class;
  protected $vrfDataType = '';
  /**
   * Optional. The name of a pre-existing Vrf that the network should be
   * attached to. Format is `vrfs/{vrf}`.
   *
   * @var string
   */
  public $vrfAttachment;

  /**
   * The cidr of the Network.
   *
   * @param string $cidr
   */
  public function setCidr($cidr)
  {
    $this->cidr = $cidr;
  }
  /**
   * @return string
   */
  public function getCidr()
  {
    return $this->cidr;
  }
  /**
   * Output only. Gateway ip address.
   *
   * @param string $gatewayIp
   */
  public function setGatewayIp($gatewayIp)
  {
    $this->gatewayIp = $gatewayIp;
  }
  /**
   * @return string
   */
  public function getGatewayIp()
  {
    return $this->gatewayIp;
  }
  /**
   * An identifier for the `Network`, generated by the backend.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * IP address configured.
   *
   * @param string $ipAddress
   */
  public function setIpAddress($ipAddress)
  {
    $this->ipAddress = $ipAddress;
  }
  /**
   * @return string
   */
  public function getIpAddress()
  {
    return $this->ipAddress;
  }
  /**
   * Whether network uses standard frames or jumbo ones.
   *
   * @param bool $jumboFramesEnabled
   */
  public function setJumboFramesEnabled($jumboFramesEnabled)
  {
    $this->jumboFramesEnabled = $jumboFramesEnabled;
  }
  /**
   * @return bool
   */
  public function getJumboFramesEnabled()
  {
    return $this->jumboFramesEnabled;
  }
  /**
   * Labels as key value pairs.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * List of physical interfaces.
   *
   * @param string[] $macAddress
   */
  public function setMacAddress($macAddress)
  {
    $this->macAddress = $macAddress;
  }
  /**
   * @return string[]
   */
  public function getMacAddress()
  {
    return $this->macAddress;
  }
  /**
   * Input only. List of mount points to attach the network to.
   *
   * @param NetworkMountPoint[] $mountPoints
   */
  public function setMountPoints($mountPoints)
  {
    $this->mountPoints = $mountPoints;
  }
  /**
   * @return NetworkMountPoint[]
   */
  public function getMountPoints()
  {
    return $this->mountPoints;
  }
  /**
   * Output only. The resource name of this `Network`. Resource names are
   * schemeless URIs that follow the conventions in
   * https://cloud.google.com/apis/design/resource_names. Format:
   * `projects/{project}/locations/{location}/networks/{network}`
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Immutable. Pod name. Pod is an independent part of infrastructure. Network
   * can only be connected to the assets (instances, nfsshares) allocated in the
   * same pod.
   *
   * @param string $pod
   */
  public function setPod($pod)
  {
    $this->pod = $pod;
  }
  /**
   * @return string
   */
  public function getPod()
  {
    return $this->pod;
  }
  /**
   * List of IP address reservations in this network. When updating this field,
   * an error will be generated if a reservation conflicts with an IP address
   * already allocated to a physical server.
   *
   * @param NetworkAddressReservation[] $reservations
   */
  public function setReservations($reservations)
  {
    $this->reservations = $reservations;
  }
  /**
   * @return NetworkAddressReservation[]
   */
  public function getReservations()
  {
    return $this->reservations;
  }
  /**
   * IP range for reserved for services (e.g. NFS).
   *
   * @param string $servicesCidr
   */
  public function setServicesCidr($servicesCidr)
  {
    $this->servicesCidr = $servicesCidr;
  }
  /**
   * @return string
   */
  public function getServicesCidr()
  {
    return $this->servicesCidr;
  }
  /**
   * The Network state.
   *
   * Accepted values: STATE_UNSPECIFIED, PROVISIONING, PROVISIONED,
   * DEPROVISIONING, UPDATING
   *
   * @param self::STATE_* $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return self::STATE_*
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * The type of this network.
   *
   * Accepted values: TYPE_UNSPECIFIED, CLIENT, PRIVATE
   *
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * The vlan id of the Network.
   *
   * @param string $vlanId
   */
  public function setVlanId($vlanId)
  {
    $this->vlanId = $vlanId;
  }
  /**
   * @return string
   */
  public function getVlanId()
  {
    return $this->vlanId;
  }
  /**
   * The Vrf for the Network. Use this only if a new Vrf needs to be created.
   *
   * @param VRF $vrf
   */
  public function setVrf(VRF $vrf)
  {
    $this->vrf = $vrf;
  }
  /**
   * @return VRF
   */
  public function getVrf()
  {
    return $this->vrf;
  }
  /**
   * Optional. The name of a pre-existing Vrf that the network should be
   * attached to. Format is `vrfs/{vrf}`.
   *
   * @param string $vrfAttachment
   */
  public function setVrfAttachment($vrfAttachment)
  {
    $this->vrfAttachment = $vrfAttachment;
  }
  /**
   * @return string
   */
  public function getVrfAttachment()
  {
    return $this->vrfAttachment;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Network::class, 'Google_Service_Baremetalsolution_Network');
