<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Backupdr;

class NetworkInterface extends \Google\Collection
{
  /**
   * IPv6 access type not set. Means this network interface hasn't been turned
   * on IPv6 yet.
   */
  public const IPV6_ACCESS_TYPE_UNSPECIFIED_IPV6_ACCESS_TYPE = 'UNSPECIFIED_IPV6_ACCESS_TYPE';
  /**
   * This network interface can have internal IPv6.
   */
  public const IPV6_ACCESS_TYPE_INTERNAL = 'INTERNAL';
  /**
   * This network interface can have external IPv6.
   */
  public const IPV6_ACCESS_TYPE_EXTERNAL = 'EXTERNAL';
  /**
   * Default should be NIC_TYPE_UNSPECIFIED.
   */
  public const NIC_TYPE_NIC_TYPE_UNSPECIFIED = 'NIC_TYPE_UNSPECIFIED';
  /**
   * VIRTIO
   */
  public const NIC_TYPE_VIRTIO_NET = 'VIRTIO_NET';
  /**
   * GVNIC
   */
  public const NIC_TYPE_GVNIC = 'GVNIC';
  /**
   * Default should be STACK_TYPE_UNSPECIFIED.
   */
  public const STACK_TYPE_STACK_TYPE_UNSPECIFIED = 'STACK_TYPE_UNSPECIFIED';
  /**
   * The network interface will be assigned IPv4 address.
   */
  public const STACK_TYPE_IPV4_ONLY = 'IPV4_ONLY';
  /**
   * The network interface can have both IPv4 and IPv6 addresses.
   */
  public const STACK_TYPE_IPV4_IPV6 = 'IPV4_IPV6';
  protected $collection_key = 'ipv6AccessConfigs';
  protected $accessConfigsType = AccessConfig::class;
  protected $accessConfigsDataType = 'array';
  protected $aliasIpRangesType = AliasIpRange::class;
  protected $aliasIpRangesDataType = 'array';
  /**
   * Optional. The prefix length of the primary internal IPv6 range.
   *
   * @var int
   */
  public $internalIpv6PrefixLength;
  protected $ipv6AccessConfigsType = AccessConfig::class;
  protected $ipv6AccessConfigsDataType = 'array';
  /**
   * Optional. [Output Only] One of EXTERNAL, INTERNAL to indicate whether the
   * IP can be accessed from the Internet. This field is always inherited from
   * its subnetwork.
   *
   * @var string
   */
  public $ipv6AccessType;
  /**
   * Optional. An IPv6 internal network address for this network interface. To
   * use a static internal IP address, it must be unused and in the same region
   * as the instance's zone. If not specified, Google Cloud will automatically
   * assign an internal IPv6 address from the instance's subnetwork.
   *
   * @var string
   */
  public $ipv6Address;
  /**
   * Output only. [Output Only] The name of the network interface, which is
   * generated by the server.
   *
   * @var string
   */
  public $name;
  /**
   * Optional. URL of the VPC network resource for this instance.
   *
   * @var string
   */
  public $network;
  /**
   * Optional. The URL of the network attachment that this interface should
   * connect to in the following format: projects/{project_number}/regions/{regi
   * on_name}/networkAttachments/{network_attachment_name}.
   *
   * @var string
   */
  public $networkAttachment;
  /**
   * Optional. An IPv4 internal IP address to assign to the instance for this
   * network interface. If not specified by the user, an unused internal IP is
   * assigned by the system.
   *
   * @var string
   */
  public $networkIP;
  /**
   * Optional. The type of vNIC to be used on this interface. This may be gVNIC
   * or VirtioNet.
   *
   * @var string
   */
  public $nicType;
  /**
   * Optional. The networking queue count that's specified by users for the
   * network interface. Both Rx and Tx queues will be set to this number. It'll
   * be empty if not specified by the users.
   *
   * @var int
   */
  public $queueCount;
  /**
   * The stack type for this network interface.
   *
   * @var string
   */
  public $stackType;
  /**
   * Optional. The URL of the Subnetwork resource for this instance.
   *
   * @var string
   */
  public $subnetwork;

  /**
   * Optional. An array of configurations for this interface. Currently, only
   * one access config,ONE_TO_ONE_NAT is supported. If there are no
   * accessConfigs specified, then this instance will have no external internet
   * access.
   *
   * @param AccessConfig[] $accessConfigs
   */
  public function setAccessConfigs($accessConfigs)
  {
    $this->accessConfigs = $accessConfigs;
  }
  /**
   * @return AccessConfig[]
   */
  public function getAccessConfigs()
  {
    return $this->accessConfigs;
  }
  /**
   * Optional. An array of alias IP ranges for this network interface. You can
   * only specify this field for network interfaces in VPC networks.
   *
   * @param AliasIpRange[] $aliasIpRanges
   */
  public function setAliasIpRanges($aliasIpRanges)
  {
    $this->aliasIpRanges = $aliasIpRanges;
  }
  /**
   * @return AliasIpRange[]
   */
  public function getAliasIpRanges()
  {
    return $this->aliasIpRanges;
  }
  /**
   * Optional. The prefix length of the primary internal IPv6 range.
   *
   * @param int $internalIpv6PrefixLength
   */
  public function setInternalIpv6PrefixLength($internalIpv6PrefixLength)
  {
    $this->internalIpv6PrefixLength = $internalIpv6PrefixLength;
  }
  /**
   * @return int
   */
  public function getInternalIpv6PrefixLength()
  {
    return $this->internalIpv6PrefixLength;
  }
  /**
   * Optional. An array of IPv6 access configurations for this interface.
   * Currently, only one IPv6 access config, DIRECT_IPV6, is supported. If there
   * is no ipv6AccessConfig specified, then this instance will have no external
   * IPv6 Internet access.
   *
   * @param AccessConfig[] $ipv6AccessConfigs
   */
  public function setIpv6AccessConfigs($ipv6AccessConfigs)
  {
    $this->ipv6AccessConfigs = $ipv6AccessConfigs;
  }
  /**
   * @return AccessConfig[]
   */
  public function getIpv6AccessConfigs()
  {
    return $this->ipv6AccessConfigs;
  }
  /**
   * Optional. [Output Only] One of EXTERNAL, INTERNAL to indicate whether the
   * IP can be accessed from the Internet. This field is always inherited from
   * its subnetwork.
   *
   * Accepted values: UNSPECIFIED_IPV6_ACCESS_TYPE, INTERNAL, EXTERNAL
   *
   * @param self::IPV6_ACCESS_TYPE_* $ipv6AccessType
   */
  public function setIpv6AccessType($ipv6AccessType)
  {
    $this->ipv6AccessType = $ipv6AccessType;
  }
  /**
   * @return self::IPV6_ACCESS_TYPE_*
   */
  public function getIpv6AccessType()
  {
    return $this->ipv6AccessType;
  }
  /**
   * Optional. An IPv6 internal network address for this network interface. To
   * use a static internal IP address, it must be unused and in the same region
   * as the instance's zone. If not specified, Google Cloud will automatically
   * assign an internal IPv6 address from the instance's subnetwork.
   *
   * @param string $ipv6Address
   */
  public function setIpv6Address($ipv6Address)
  {
    $this->ipv6Address = $ipv6Address;
  }
  /**
   * @return string
   */
  public function getIpv6Address()
  {
    return $this->ipv6Address;
  }
  /**
   * Output only. [Output Only] The name of the network interface, which is
   * generated by the server.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. URL of the VPC network resource for this instance.
   *
   * @param string $network
   */
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  /**
   * @return string
   */
  public function getNetwork()
  {
    return $this->network;
  }
  /**
   * Optional. The URL of the network attachment that this interface should
   * connect to in the following format: projects/{project_number}/regions/{regi
   * on_name}/networkAttachments/{network_attachment_name}.
   *
   * @param string $networkAttachment
   */
  public function setNetworkAttachment($networkAttachment)
  {
    $this->networkAttachment = $networkAttachment;
  }
  /**
   * @return string
   */
  public function getNetworkAttachment()
  {
    return $this->networkAttachment;
  }
  /**
   * Optional. An IPv4 internal IP address to assign to the instance for this
   * network interface. If not specified by the user, an unused internal IP is
   * assigned by the system.
   *
   * @param string $networkIP
   */
  public function setNetworkIP($networkIP)
  {
    $this->networkIP = $networkIP;
  }
  /**
   * @return string
   */
  public function getNetworkIP()
  {
    return $this->networkIP;
  }
  /**
   * Optional. The type of vNIC to be used on this interface. This may be gVNIC
   * or VirtioNet.
   *
   * Accepted values: NIC_TYPE_UNSPECIFIED, VIRTIO_NET, GVNIC
   *
   * @param self::NIC_TYPE_* $nicType
   */
  public function setNicType($nicType)
  {
    $this->nicType = $nicType;
  }
  /**
   * @return self::NIC_TYPE_*
   */
  public function getNicType()
  {
    return $this->nicType;
  }
  /**
   * Optional. The networking queue count that's specified by users for the
   * network interface. Both Rx and Tx queues will be set to this number. It'll
   * be empty if not specified by the users.
   *
   * @param int $queueCount
   */
  public function setQueueCount($queueCount)
  {
    $this->queueCount = $queueCount;
  }
  /**
   * @return int
   */
  public function getQueueCount()
  {
    return $this->queueCount;
  }
  /**
   * The stack type for this network interface.
   *
   * Accepted values: STACK_TYPE_UNSPECIFIED, IPV4_ONLY, IPV4_IPV6
   *
   * @param self::STACK_TYPE_* $stackType
   */
  public function setStackType($stackType)
  {
    $this->stackType = $stackType;
  }
  /**
   * @return self::STACK_TYPE_*
   */
  public function getStackType()
  {
    return $this->stackType;
  }
  /**
   * Optional. The URL of the Subnetwork resource for this instance.
   *
   * @param string $subnetwork
   */
  public function setSubnetwork($subnetwork)
  {
    $this->subnetwork = $subnetwork;
  }
  /**
   * @return string
   */
  public function getSubnetwork()
  {
    return $this->subnetwork;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(NetworkInterface::class, 'Google_Service_Backupdr_NetworkInterface');
