<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict extends \Google\Model
{
  protected $conflictingDeploymentType = GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment::class;
  protected $conflictingDeploymentDataType = '';
  /**
   * Human-readable description of this conflict.
   *
   * @var string
   */
  public $description;
  /**
   * Name of the environment group in which this conflict exists.
   *
   * @var string
   */
  public $environmentGroup;

  /**
   * Existing base path/deployment causing the conflict.
   *
   * @param GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment $conflictingDeployment
   */
  public function setConflictingDeployment(GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment $conflictingDeployment)
  {
    $this->conflictingDeployment = $conflictingDeployment;
  }
  /**
   * @return GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment
   */
  public function getConflictingDeployment()
  {
    return $this->conflictingDeployment;
  }
  /**
   * Human-readable description of this conflict.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Name of the environment group in which this conflict exists.
   *
   * @param string $environmentGroup
   */
  public function setEnvironmentGroup($environmentGroup)
  {
    $this->environmentGroup = $environmentGroup;
  }
  /**
   * @return string
   */
  public function getEnvironmentGroup()
  {
    return $this->environmentGroup;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict::class, 'Google_Service_Apigee_GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict');
