<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Apigee;

class GoogleCloudApigeeV1ApiProxy extends \Google\Collection
{
  /**
   * API proxy type not specified.
   */
  public const API_PROXY_TYPE_API_PROXY_TYPE_UNSPECIFIED = 'API_PROXY_TYPE_UNSPECIFIED';
  /**
   * Programmable API Proxies enable you to develop APIs with highly flexible
   * behavior using bundled policy configuration and one or more programming
   * languages to describe complex sequential and/or conditional flows of logic.
   */
  public const API_PROXY_TYPE_PROGRAMMABLE = 'PROGRAMMABLE';
  /**
   * Configurable API Proxies enable you to develop efficient APIs using simple
   * configuration while complex execution control flow logic is handled by
   * Apigee. This type only works with the ARCHIVE deployment type and cannot be
   * combined with the PROXY deployment type.
   */
  public const API_PROXY_TYPE_CONFIGURABLE = 'CONFIGURABLE';
  protected $collection_key = 'revision';
  /**
   * Output only. The type of the API proxy.
   *
   * @var string
   */
  public $apiProxyType;
  /**
   * User labels applied to this API Proxy.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Output only. The id of the most recently created revision for this api
   * proxy.
   *
   * @var string
   */
  public $latestRevisionId;
  protected $metaDataType = GoogleCloudApigeeV1EntityMetadata::class;
  protected $metaDataDataType = '';
  /**
   * Output only. Name of the API proxy.
   *
   * @var string
   */
  public $name;
  /**
   * Output only. Whether this proxy is read-only. A read-only proxy cannot have
   * new revisions created through calls to CreateApiProxyRevision. A proxy is
   * read-only if it was generated by an archive.
   *
   * @var bool
   */
  public $readOnly;
  /**
   * Output only. List of revisions defined for the API proxy.
   *
   * @var string[]
   */
  public $revision;
  /**
   * Optional. The id of the space this proxy is associated with. Any IAM
   * policies applied to the space will control access to this proxy. To learn
   * how Spaces can be used to manage resources, read the [Apigee Spaces
   * Overview](https://cloud.google.com/apigee/docs/api-platform/system-
   * administration/spaces/apigee-spaces-overview).
   *
   * @var string
   */
  public $space;

  /**
   * Output only. The type of the API proxy.
   *
   * Accepted values: API_PROXY_TYPE_UNSPECIFIED, PROGRAMMABLE, CONFIGURABLE
   *
   * @param self::API_PROXY_TYPE_* $apiProxyType
   */
  public function setApiProxyType($apiProxyType)
  {
    $this->apiProxyType = $apiProxyType;
  }
  /**
   * @return self::API_PROXY_TYPE_*
   */
  public function getApiProxyType()
  {
    return $this->apiProxyType;
  }
  /**
   * User labels applied to this API Proxy.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Output only. The id of the most recently created revision for this api
   * proxy.
   *
   * @param string $latestRevisionId
   */
  public function setLatestRevisionId($latestRevisionId)
  {
    $this->latestRevisionId = $latestRevisionId;
  }
  /**
   * @return string
   */
  public function getLatestRevisionId()
  {
    return $this->latestRevisionId;
  }
  /**
   * Output only. Metadata describing the API proxy.
   *
   * @param GoogleCloudApigeeV1EntityMetadata $metaData
   */
  public function setMetaData(GoogleCloudApigeeV1EntityMetadata $metaData)
  {
    $this->metaData = $metaData;
  }
  /**
   * @return GoogleCloudApigeeV1EntityMetadata
   */
  public function getMetaData()
  {
    return $this->metaData;
  }
  /**
   * Output only. Name of the API proxy.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Output only. Whether this proxy is read-only. A read-only proxy cannot have
   * new revisions created through calls to CreateApiProxyRevision. A proxy is
   * read-only if it was generated by an archive.
   *
   * @param bool $readOnly
   */
  public function setReadOnly($readOnly)
  {
    $this->readOnly = $readOnly;
  }
  /**
   * @return bool
   */
  public function getReadOnly()
  {
    return $this->readOnly;
  }
  /**
   * Output only. List of revisions defined for the API proxy.
   *
   * @param string[] $revision
   */
  public function setRevision($revision)
  {
    $this->revision = $revision;
  }
  /**
   * @return string[]
   */
  public function getRevision()
  {
    return $this->revision;
  }
  /**
   * Optional. The id of the space this proxy is associated with. Any IAM
   * policies applied to the space will control access to this proxy. To learn
   * how Spaces can be used to manage resources, read the [Apigee Spaces
   * Overview](https://cloud.google.com/apigee/docs/api-platform/system-
   * administration/spaces/apigee-spaces-overview).
   *
   * @param string $space
   */
  public function setSpace($space)
  {
    $this->space = $space;
  }
  /**
   * @return string
   */
  public function getSpace()
  {
    return $this->space;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApigeeV1ApiProxy::class, 'Google_Service_Apigee_GoogleCloudApigeeV1ApiProxy');
