<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidProvisioningPartner;

class CreateCustomerRequest extends \Google\Model
{
  protected $customerType = Company::class;
  protected $customerDataType = '';

  /**
   * Required. The company data to populate the new customer. Must contain a
   * value for `companyName` and at least one `owner_email` that's associated
   * with a Google Account. The values for `companyId` and `name` must be empty.
   *
   * @param Company $customer
   */
  public function setCustomer(Company $customer)
  {
    $this->customer = $customer;
  }
  /**
   * @return Company
   */
  public function getCustomer()
  {
    return $this->customer;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(CreateCustomerRequest::class, 'Google_Service_AndroidProvisioningPartner_CreateCustomerRequest');
