<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AndroidManagement;

class EnrollmentToken extends \Google\Model
{
  /**
   * Personal usage restriction is not specified
   */
  public const ALLOW_PERSONAL_USAGE_ALLOW_PERSONAL_USAGE_UNSPECIFIED = 'ALLOW_PERSONAL_USAGE_UNSPECIFIED';
  /**
   * Personal usage is allowed
   */
  public const ALLOW_PERSONAL_USAGE_PERSONAL_USAGE_ALLOWED = 'PERSONAL_USAGE_ALLOWED';
  /**
   * Personal usage is disallowed
   */
  public const ALLOW_PERSONAL_USAGE_PERSONAL_USAGE_DISALLOWED = 'PERSONAL_USAGE_DISALLOWED';
  /**
   * Device is not associated with a single user, and thus both personal usage
   * and corporate identity authentication are not expected. Important: This
   * setting is mandatory for dedicated device enrollment and it is a breaking
   * change. This change needs to be implemented before January 2025.For
   * additional details see the dedicated device provisioning guide
   * (https://developers.google.com/android/management/provision-device#company-
   * owned_devices_for_work_use_only).
   */
  public const ALLOW_PERSONAL_USAGE_PERSONAL_USAGE_DISALLOWED_USERLESS = 'PERSONAL_USAGE_DISALLOWED_USERLESS';
  /**
   * Optional, arbitrary data associated with the enrollment token. This could
   * contain, for example, the ID of an org unit the device is assigned to after
   * enrollment. After a device enrolls with the token, this data will be
   * exposed in the enrollment_token_data field of the Device resource. The data
   * must be 1024 characters or less; otherwise, the creation request will fail.
   *
   * @var string
   */
  public $additionalData;
  /**
   * Controls whether personal usage is allowed on a device provisioned with
   * this enrollment token.For company-owned devices: Enabling personal usage
   * allows the user to set up a work profile on the device. Disabling personal
   * usage requires the user provision the device as a fully managed device.For
   * personally-owned devices: Enabling personal usage allows the user to set up
   * a work profile on the device. Disabling personal usage will prevent the
   * device from provisioning. Personal usage cannot be disabled on personally-
   * owned device.
   *
   * @var string
   */
  public $allowPersonalUsage;
  /**
   * The length of time the enrollment token is valid, ranging from 1 minute to
   * Durations.MAX_VALUE (https://developers.google.com/protocol-buffers/docs/re
   * ference/java/com/google/protobuf/util/Durations.html#MAX_VALUE),
   * approximately 10,000 years. If not specified, the default duration is 1
   * hour. Please note that if requested duration causes the resulting
   * expiration_timestamp to exceed Timestamps.MAX_VALUE
   * (https://developers.google.com/protocol-buffers/docs/reference/java/com/goo
   * gle/protobuf/util/Timestamps.html#MAX_VALUE), then expiration_timestamp is
   * coerced to Timestamps.MAX_VALUE.
   *
   * @var string
   */
  public $duration;
  /**
   * The expiration time of the token. This is a read-only field generated by
   * the server.
   *
   * @var string
   */
  public $expirationTimestamp;
  /**
   * The name of the enrollment token, which is generated by the server during
   * creation, in the form
   * enterprises/{enterpriseId}/enrollmentTokens/{enrollmentTokenId}.
   *
   * @var string
   */
  public $name;
  /**
   * Whether the enrollment token is for one time use only. If the flag is set
   * to true, only one device can use it for registration.
   *
   * @var bool
   */
  public $oneTimeOnly;
  /**
   * The name of the policy initially applied to the enrolled device, in the
   * form enterprises/{enterpriseId}/policies/{policyId}. If not specified, the
   * policy_name for the device’s user is applied. If user_name is also not
   * specified, enterprises/{enterpriseId}/policies/default is applied by
   * default. When updating this field, you can specify only the policyId as
   * long as the policyId doesn’t contain any slashes. The rest of the policy
   * name will be inferred.
   *
   * @var string
   */
  public $policyName;
  /**
   * A JSON string whose UTF-8 representation can be used to generate a QR code
   * to enroll a device with this enrollment token. To enroll a device using
   * NFC, the NFC record must contain a serialized java.util.Properties
   * representation of the properties in the JSON.
   *
   * @var string
   */
  public $qrCode;
  protected $userType = User::class;
  protected $userDataType = '';
  /**
   * The token value that's passed to the device and authorizes the device to
   * enroll. This is a read-only field generated by the server.
   *
   * @var string
   */
  public $value;

  /**
   * Optional, arbitrary data associated with the enrollment token. This could
   * contain, for example, the ID of an org unit the device is assigned to after
   * enrollment. After a device enrolls with the token, this data will be
   * exposed in the enrollment_token_data field of the Device resource. The data
   * must be 1024 characters or less; otherwise, the creation request will fail.
   *
   * @param string $additionalData
   */
  public function setAdditionalData($additionalData)
  {
    $this->additionalData = $additionalData;
  }
  /**
   * @return string
   */
  public function getAdditionalData()
  {
    return $this->additionalData;
  }
  /**
   * Controls whether personal usage is allowed on a device provisioned with
   * this enrollment token.For company-owned devices: Enabling personal usage
   * allows the user to set up a work profile on the device. Disabling personal
   * usage requires the user provision the device as a fully managed device.For
   * personally-owned devices: Enabling personal usage allows the user to set up
   * a work profile on the device. Disabling personal usage will prevent the
   * device from provisioning. Personal usage cannot be disabled on personally-
   * owned device.
   *
   * Accepted values: ALLOW_PERSONAL_USAGE_UNSPECIFIED, PERSONAL_USAGE_ALLOWED,
   * PERSONAL_USAGE_DISALLOWED, PERSONAL_USAGE_DISALLOWED_USERLESS
   *
   * @param self::ALLOW_PERSONAL_USAGE_* $allowPersonalUsage
   */
  public function setAllowPersonalUsage($allowPersonalUsage)
  {
    $this->allowPersonalUsage = $allowPersonalUsage;
  }
  /**
   * @return self::ALLOW_PERSONAL_USAGE_*
   */
  public function getAllowPersonalUsage()
  {
    return $this->allowPersonalUsage;
  }
  /**
   * The length of time the enrollment token is valid, ranging from 1 minute to
   * Durations.MAX_VALUE (https://developers.google.com/protocol-buffers/docs/re
   * ference/java/com/google/protobuf/util/Durations.html#MAX_VALUE),
   * approximately 10,000 years. If not specified, the default duration is 1
   * hour. Please note that if requested duration causes the resulting
   * expiration_timestamp to exceed Timestamps.MAX_VALUE
   * (https://developers.google.com/protocol-buffers/docs/reference/java/com/goo
   * gle/protobuf/util/Timestamps.html#MAX_VALUE), then expiration_timestamp is
   * coerced to Timestamps.MAX_VALUE.
   *
   * @param string $duration
   */
  public function setDuration($duration)
  {
    $this->duration = $duration;
  }
  /**
   * @return string
   */
  public function getDuration()
  {
    return $this->duration;
  }
  /**
   * The expiration time of the token. This is a read-only field generated by
   * the server.
   *
   * @param string $expirationTimestamp
   */
  public function setExpirationTimestamp($expirationTimestamp)
  {
    $this->expirationTimestamp = $expirationTimestamp;
  }
  /**
   * @return string
   */
  public function getExpirationTimestamp()
  {
    return $this->expirationTimestamp;
  }
  /**
   * The name of the enrollment token, which is generated by the server during
   * creation, in the form
   * enterprises/{enterpriseId}/enrollmentTokens/{enrollmentTokenId}.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Whether the enrollment token is for one time use only. If the flag is set
   * to true, only one device can use it for registration.
   *
   * @param bool $oneTimeOnly
   */
  public function setOneTimeOnly($oneTimeOnly)
  {
    $this->oneTimeOnly = $oneTimeOnly;
  }
  /**
   * @return bool
   */
  public function getOneTimeOnly()
  {
    return $this->oneTimeOnly;
  }
  /**
   * The name of the policy initially applied to the enrolled device, in the
   * form enterprises/{enterpriseId}/policies/{policyId}. If not specified, the
   * policy_name for the device’s user is applied. If user_name is also not
   * specified, enterprises/{enterpriseId}/policies/default is applied by
   * default. When updating this field, you can specify only the policyId as
   * long as the policyId doesn’t contain any slashes. The rest of the policy
   * name will be inferred.
   *
   * @param string $policyName
   */
  public function setPolicyName($policyName)
  {
    $this->policyName = $policyName;
  }
  /**
   * @return string
   */
  public function getPolicyName()
  {
    return $this->policyName;
  }
  /**
   * A JSON string whose UTF-8 representation can be used to generate a QR code
   * to enroll a device with this enrollment token. To enroll a device using
   * NFC, the NFC record must contain a serialized java.util.Properties
   * representation of the properties in the JSON.
   *
   * @param string $qrCode
   */
  public function setQrCode($qrCode)
  {
    $this->qrCode = $qrCode;
  }
  /**
   * @return string
   */
  public function getQrCode()
  {
    return $this->qrCode;
  }
  /**
   * This field is deprecated and the value is ignored.
   *
   * @deprecated
   * @param User $user
   */
  public function setUser(User $user)
  {
    $this->user = $user;
  }
  /**
   * @deprecated
   * @return User
   */
  public function getUser()
  {
    return $this->user;
  }
  /**
   * The token value that's passed to the device and authorizes the device to
   * enroll. This is a read-only field generated by the server.
   *
   * @param string $value
   */
  public function setValue($value)
  {
    $this->value = $value;
  }
  /**
   * @return string
   */
  public function getValue()
  {
    return $this->value;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(EnrollmentToken::class, 'Google_Service_AndroidManagement_EnrollmentToken');
