<?php

$image_size = (int) (setting('_general.max_image_size') ?? '5');

return [
    'section' => [
        'id'     => '_email',
        'label'  => __('admin/sidebar.email_settings'),
        'tabs'          => true,
        'icon'   => '',
    ],
    'fields' => [
        [
            'id'            => 'email_logo',
            'type'          => 'file',
            'tab_id'        => 'general_setting',
            'tab_title'     => __('settings.general'),
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.logo'),
            'field_desc'    => __('admin/optionbuilder.image_option', ['extension' => 'jpg, png, svg, jpeg', 'size' => $image_size . 'mb']),
            'max_size'   => $image_size,                  // size in MB
            'ext'    => [
                'jpg',
                'png',
                'svg',
                'jpeg',
                'webp',
            ],
        ],
        [
            'id'            => 'sender_name',
            'type'          => 'text',
            'tab_id'        => 'general_setting',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.sender_name'),
            'field_desc'   => __('admin/optionbuilder.sender_name_desc'),
            'placeholder'   => __('admin/optionbuilder.sender_name'),
            'hint'     => [
                'content' => __('admin/optionbuilder.sender_name'),
            ],
        ],
        [
            'id'            => 'sender_email',
            'type'          => 'text',
            'tab_id'        => 'general_setting',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.sender_email'),
            'field_desc'   => __('admin/optionbuilder.sender_email_desc'),
            'placeholder'   => __('admin/optionbuilder.sender_email'),
            'hint'     => [
                'content' => __('admin/optionbuilder.sender_email'),
            ],
        ],
        [
            'id'            => 'sender_signature',
            'type'          => 'textarea',
            'tab_id'        => 'general_setting',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.sender_signature'),
            'field_desc'   => __('admin/optionbuilder.sender_signature_desc', ['app_name' => env('APP_NAME')]),
            'placeholder'   => __('admin/optionbuilder.sender_signature'),
        ],
        [
            'id'            => 'footer_text',
            'type'          => 'text',
            'tab_id'        => 'general_setting',
            'tab_title'     => __('settings.general'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('admin/optionbuilder.footer_text'),
            'field_desc'   => __('admin/optionbuilder.footer_text_desc'),
            'placeholder'   => __('admin/optionbuilder.footer_text'),
            'hint'     => [
                'content' => __('admin/optionbuilder.footer_text'),
            ],
        ],
        [
            'id'            => 'smtp_host',
            'type'          => 'text',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.smtp_host'),
            'field_desc'   => __('settings.smtp_host_desc'),
            'placeholder'   => __('settings.smtp_host'),
        ],
        [
            'id'            => 'smtp_port',
            'type'          => 'text',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.smtp_port'),
            'field_desc'   => __('settings.smtp_port_desc'),
            'placeholder'   => __('settings.smtp_port'),
        ],
        [
            'id'            => 'smtp_username',
            'type'          => 'text',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.smtp_username'),
            'field_desc'   => __('settings.smtp_username_desc'),
            'placeholder'   => __('settings.smtp_username'),
        ],
        [
            'id'            => 'smtp_password',
            'type'          => 'text',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'value'         => '',
            'class'         => '',
            'label_title'   => __('settings.smtp_password'),
            'field_desc'   => __('settings.smtp_password_desc'),
            'placeholder'   => __('settings.smtp_password'),
        ],
        [
            'id'            => 'smtp_encryption',
            'type'          => 'select',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'class'         => '',
            'label_title'   => __('settings.smtp_encryption'),
            'field_desc'   => __('settings.smtp_encryption_desc'),
            'options'       => [
                'none'  => 'None',
                'ssl'   => 'SSL',
                'tls'   => 'TLS',
            ],
            'default'       => 'none',
            'placeholder'   => __('settings.select_from_list'),
        ],
        [
            'id'            => 'smtp_from_email',
            'type'          => 'text',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'class'         => '',
            'label_title'   => __('settings.smtp_from_email'),
            'field_desc'   => __('settings.smtp_from_email_desc'),
            'placeholder'   => __('settings.smtp_from_email'),
        ],
        [
            'id'            => 'smtp_from_name',
            'type'          => 'text',
            'tab_id'        => 'smtp_setting',
            'tab_title'     => __('settings.smtp_settings'),
            'class'         => '',
            'label_title'   => __('settings.smtp_from_name'),
            'field_desc'   => __('settings.smtp_from_name_desc'),
            'placeholder'   => __('settings.smtp_from_name'),
        ],
    ]
];
